#ifdef _WIN32_WINNT

#ifndef _HDJ2534HANDLER_
#define _HDJ2534HANDLER_

#define APP_BUILD
#include <Windows.h>
#include "hdj2534.h"
#include <iostream>
using namespace J2534;
using namespace std;

typedef J2534_ERROR_CODE (*PassThruOpen_t)(void *pName, unsigned long *pDeviceID);
typedef J2534_ERROR_CODE (*PassThruClose_t)(unsigned long pDeviceID);
typedef J2534_ERROR_CODE (*PassThruConnect_t)(unsigned long DeviceID, J2534_PROTOCOL  ProtocolID, unsigned long Flags, unsigned long BaudRate, unsigned long *pChannelID);
typedef J2534_ERROR_CODE (*PassThruDisconnect_t)(unsigned long ChannelID);
typedef J2534_ERROR_CODE (*PassThruReadMsgs_t)(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pNumMsgs, unsigned long Timeout);
typedef J2534_ERROR_CODE (*PassThruWriteMsgs_t)(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pNumMsgs, unsigned long Timeout);
typedef J2534_ERROR_CODE (*PassThruStartPeriodicMsg_t)(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pMsgID, unsigned long TimeInterval);
typedef J2534_ERROR_CODE (*PassThruStopPeriodicMsg_t)(unsigned long ChannelID, unsigned long MsgID);
typedef J2534_ERROR_CODE (*PassThruStartMsgFilter_t)(unsigned long ChannelID, J2534_FILTER FilterType, PASSTHRU_MSG *pMaskMsg, PASSTHRU_MSG *pPatternMsg, PASSTHRU_MSG *pFlowControlMsg, unsigned long *pFilterID);
typedef J2534_ERROR_CODE (*PassThruStopMsgFilter_t)(unsigned long ChannelID, unsigned long FilterID);
typedef J2534_ERROR_CODE (*PassThruGetLastError_t)(char *pErrorDescription);
typedef J2534_ERROR_CODE (*PassThruIoctl_t)(unsigned long ChannelID, J2534_IOCTL IoctlID, void *pInput, void  *pOutput);
typedef J2534_ERROR_CODE (*PassThruSetProgrammingVoltage_t)(unsigned long DeviceID, unsigned long PinNumber, unsigned long Voltage);
typedef J2534_ERROR_CODE (*PassThruReadVersion_t)(unsigned long DeviceID, char *pFirmwareVersion, char *pLibVersion, char *pApiVersion);
typedef J2534_ERROR_CODE (*PassThruGetStatus_t)(unsigned long ChannelID, unsigned long *status);
typedef J2534_ERROR_CODE (*PassThruReset_t)(void);

extern PassThruOpen_t PassThruOpen;
extern PassThruClose_t PassThruClose;
extern PassThruConnect_t PassThruConnect;
extern PassThruDisconnect_t PassThruDisconnect;
extern PassThruReadMsgs_t PassThruReadMsgs;
extern PassThruWriteMsgs_t PassThruWriteMsgs;
extern PassThruGetLastError_t PassThruGetLastError;
extern PassThruStartPeriodicMsg_t PassThruStartPeriodicMsg;
extern PassThruStopPeriodicMsg_t PassThruStopPeriodicMsg;
extern PassThruStartMsgFilter_t PassThruStartMsgFilter;
extern PassThruStopMsgFilter_t PassThruStopMsgFilter;
extern PassThruIoctl_t PassThruIoctl;
extern PassThruSetProgrammingVoltage_t PassThruSetProgrammingVoltage;
extern PassThruReadVersion_t PassThruReadVersion;
extern PassThruGetStatus_t PassThruGetStatus;
extern PassThruReset_t PassThruReset;
extern _J2534_ERROR_CODE err;

#endif //_HDJ2534HANDLER_
#endif //_WIN32_WINNT